;;; 
;;; Virtual Disk Drive Project	- Sep 9, 2001 - EJR (in Austin)
;;;

#include "vd.h"
#include "main.h"
#include "serial.h"

;;;
;;; This routine exports the following symbols
;;; 
	global InterruptSetup      ; sets up interrupt processing
	global Interrupt           ; main interrupt routine
			
PROG1 CODE
		
;;;*******************************************************************
;;; NAME:	InterruptSetup()
;;;
;;; DESCR:	Setups the interrupt processing
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	
;;;*******************************************************************

InterruptSetup:

	BankSelect	1

	clrf	PIE1
	clrf	INTCON

	bsf	PIE1, RCIE	; interrupt on received UART byte
	bcf	PIE1, TXIE	; no interrupts on transmit done

;;; ** Fri Jan 04 19:28:21 2002 **
;;; I don't think I need to worry about responding to interrupts here,
;;; since this thing operates so slowly relative to the world.  Instead,
;;; I'll just check for the appropriate conditions when they make sense.
;;;
;;	bsf	INTCON, PEIE	; peripheral interrupt bit (UART)
;;	bsf	INTCON, RBIE	; RB port change interrupt bit

	BankSelect	0
	
	bsf	INTCON, GIE	; global interrupts on
	bsf	INTCON, PEIE	; global interrupts on

	clrf	BREAKDETECT

	return

;;;**********************************************************************
;;; NAME:	Interrupt()
;;;
;;; DESCR:	Main interrupt routine.  Dispatches as necessary
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:
;;;**********************************************************************

Interrupt:	

	;; check serial port for an error first
	
	movlw	06h		; Check for errors (FERR, OERR)
	andwf	RCSTA,W		; 
	btfss	STATUS,Z	
	goto	RcvError	; Found error

	clrf	BREAKDETECT
	
	movf	RCREG,W		; Get input data

;;; would normally check for data ready...but since there
;;; is only one possible interrupt at this point, no need
;;; (also, it was causing problems at one point)
;;; 
;;;	btfsc	PIR1,RCIF	; Check for data ready
;;;
	
	call	SerialDispatch

	RestorePage		; SavePage called while entering interrupt
	retfie
	
	;; At one point, other things were going to cause interrupts...
	;; but it was easier to poll
	;; 
	;; VD_HEAD_MOVE (RB4) - a head move requested (see VD_HEAD_DIR)
	;; VD_DRIVE_1 (RB5) - drive one enable (motor on, drive 1 sel)
	;; VD_DRIVE_2 (RB6) - driver two enable (motor on, drive 2 sel)
	;;    for the two drive interrupts, data generation begins upon
	;;    a low to hi transition, and stops on hi to low (these
	;;    really don't need to be interrupts - just check each sector)

;;;*******************************************************************
;;; NAME:	RcvError()
;;;
;;; DESCR:	Called when an error from the receiving UART occurs.
;;;		Assumes that we're in the interrupt routine when this
;;;		occurs (ie - a retfie must be done).
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	
;;;*******************************************************************
RcvError:	
	btfss	PIR1,TXIF	; Check for xmit buffer clear
	goto	RcvError	; spin until it is

	bcf	RCSTA,CREN	; Clear reciever status
	bsf	RCSTA,CREN	; re-enable continuous receive
	
	;; if W has a zero in it, then it is possible that we are
	;; in a break condition (received a zero with a frame error)
	;; if it is NOT a zero, then ignore it.  We have a break if
	;; we get 4 zeros with framing errors in a row.

	iorlw	0		; check W for a zero
	skpnz
	goto	RcvErrorIgnore

	RestorePage

	incf	BREAKDETECT
	btfsc	BREAKDETECT,2	; quick check for 4
	goto	Start		; sensed a break, reset the whole thing

	retfie

RcvErrorIgnore:
	clrf	BREAKDETECT	; just ignore the error 
	RestorePage
	retfie
	
	END
